<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HealthFileProfile extends Model 
{

    protected $table = 'health_file_profile';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'health_file_question_id', 'answer');

    public function user()
    {
        return $this->belongsTo('App\Models\Users');
    }

    public function healthFileQuestion()
    {
        return $this->belongsTo('App\Models\HealthFileQuestion');
    }

}